/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.advanced;

import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import noppes.npcs.CustomNpcs;
import noppes.npcs.client.Client;
import noppes.npcs.client.gui.select.GuiDialogSelection;
import noppes.npcs.client.gui.util.GuiCustomScroll;
import noppes.npcs.client.gui.util.GuiNPCInterface2;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcLabel;
import noppes.npcs.client.gui.util.GuiSelectionListener;
import noppes.npcs.client.gui.util.ICustomScrollListener;
import noppes.npcs.client.gui.util.IGuiCustomScroll;
import noppes.npcs.client.gui.util.IGuiData;
import noppes.npcs.client.gui.util.IGuiNpcButton;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.constants.EnumPacketServer;
import noppes.npcs.entity.EntityNPCInterface;

public class GuiNPCDialogNpcOptions
extends GuiNPCInterface2
implements GuiSelectionListener,
IGuiData,
ICustomScrollListener {
    private final HashMap<Integer, NBTTagCompound> data = new HashMap();
    private int selectedSlot = -1;
    private GuiCustomScroll scroll;
    private int error = 0;

    public GuiNPCDialogNpcOptions(EntityNPCInterface npc) {
        super(npc);
        this.drawDefaultBackground = true;
        Client.sendData(EnumPacketServer.DialogNpcGet, new Object[0]);
    }

    @Override
    public void buttonEvent(IGuiNpcButton button) {
        switch (button.getID()) {
            case 1: {
                this.selectedSlot = -1;
                this.setSubGui(new GuiDialogSelection(-1, 0));
                break;
            }
            case 2: {
                this.data.clear();
                Client.sendData(EnumPacketServer.DialogNpcRemove, this.selectedSlot);
                this.selectedSlot = -1;
                this.func_73866_w_();
                break;
            }
            case 3: {
                if (!this.data.containsKey(this.selectedSlot)) {
                    return;
                }
                this.setSubGui(new GuiDialogSelection(this.data.get(this.selectedSlot).func_74762_e("Id"), 0));
                break;
            }
            case 4: {
                if (this.selectedSlot < 1) {
                    return;
                }
                Client.sendData(EnumPacketServer.DialogNpcMove, this.selectedSlot, true);
                --this.selectedSlot;
                this.func_73866_w_();
                break;
            }
            case 5: {
                if (this.selectedSlot >= this.data.size()) {
                    return;
                }
                Client.sendData(EnumPacketServer.DialogNpcMove, this.selectedSlot, false);
                ++this.selectedSlot;
                this.func_73866_w_();
            }
        }
    }

    @Override
    public void close() {
        this.save();
        CustomNpcs.proxy.openGui(this.npc, EnumGuiType.MainMenuAdvanced);
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        if (this.error > 0) {
            if (this.scroll != null) {
                this.scroll.colorBack = -1063256064;
            }
            --this.error;
            if (this.error <= 0 && this.scroll != null) {
                this.scroll.colorBack = -1072689136;
            }
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        ArrayList<String> dialogs = new ArrayList<String>();
        for (int slot : this.data.keySet()) {
            NBTTagCompound nbt = this.data.get(slot);
            String str = slot + 1 + "; " + '\u00a7' + "7ID:" + nbt.func_74762_e("Id") + " - ";
            str = str + "\u00a78" + nbt.func_74779_i("Category") + "/";
            str = str + "\u00a7r" + nbt.func_74779_i("Title");
            dialogs.add(str);
        }
        if (this.scroll == null) {
            this.scroll = new GuiCustomScroll(this, 0);
            this.scroll.setSize(210, 196);
        }
        this.scroll.setListNotSorted(dialogs);
        this.scroll.guiLeft = this.guiLeft + 5;
        this.scroll.guiTop = this.guiTop + 14;
        if (this.selectedSlot >= 0 && this.data.containsKey(this.selectedSlot)) {
            this.scroll.setSelect(this.selectedSlot);
        } else {
            this.selectedSlot = -1;
            this.scroll.setSelect(-1);
        }
        this.addScroll(this.scroll);
        GuiNpcButton button = new GuiNpcButton(1, this.guiLeft + 220, this.guiTop + 14, 64, 20, "gui.add");
        button.setHoverText("dialog.hover.add", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(2, this.guiLeft + 220, this.guiTop + 36, 64, 20, "gui.remove");
        button.field_146124_l = this.selectedSlot >= 0;
        button.setHoverText("dialog.hover.del", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(3, this.guiLeft + 220, this.guiTop + 58, 64, 20, "advanced.editingmode");
        button.field_146124_l = this.selectedSlot >= 0;
        button.setHoverText("dialog.hover.change", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(4, this.guiLeft + 220, this.guiTop + 102, 64, 20, "type.up");
        button.field_146124_l = this.selectedSlot >= 0 && this.selectedSlot >= 1;
        button.setHoverText("dialog.hover.up", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(5, this.guiLeft + 220, this.guiTop + 124, 64, 20, "type.down");
        button.field_146124_l = this.selectedSlot >= 0 && this.selectedSlot < this.data.size() - 1;
        button.setHoverText("dialog.hover.down", new Object[0]);
        this.addButton(button);
        GuiNpcLabel label = new GuiNpcLabel(6, new TextComponentTranslation("type.help", new Object[0]).func_150254_d(), this.guiLeft + 230, this.guiTop + 150);
        label.backColor = 0x40FF0000;
        label.borderColor = -2139062144;
        label.color = -16777216;
        label.setHoverText("dialog.hover.info", new Object[0]);
        this.addLabel(label);
        this.addLabel(new GuiNpcLabel(7, new TextComponentTranslation("dialog.dialogs", new Object[0]).func_150254_d() + ":", this.guiLeft + 5, this.guiTop + 4));
    }

    @Override
    public void save() {
    }

    @Override
    public void func_73869_a(char c, int i) {
        if (i == 1 && this.subgui == null) {
            this.save();
            CustomNpcs.proxy.openGui(this.npc, EnumGuiType.MainMenuAdvanced);
        }
        super.func_73869_a(c, i);
    }

    @Override
    public void scrollClicked(int mouseX, int mouseY, int mouseButton, IGuiCustomScroll scroll) {
        this.selectedSlot = scroll.getSelect();
        this.func_73866_w_();
    }

    @Override
    public void scrollDoubleClicked(String select, IGuiCustomScroll scroll) {
        if (!this.data.containsKey(this.selectedSlot)) {
            return;
        }
        this.setSubGui(new GuiDialogSelection(this.data.get(this.selectedSlot).func_74762_e("Id"), 0));
    }

    @Override
    public void selected(int id, String name) {
        if (this.selectedSlot < 0) {
            this.selectedSlot = this.data.size();
        }
        for (int slot : this.data.keySet()) {
            if (this.selectedSlot == slot || this.data.get(slot).func_74762_e("Id") != id) continue;
            this.error = 60;
            TextComponentTranslation end = new TextComponentTranslation("trader.busy", new Object[0]);
            end.func_150256_b().func_150238_a(TextFormatting.RED);
            this.player.func_145747_a(CustomNpcs.prefix.func_150257_a((ITextComponent)new TextComponentTranslation("dialog.dialog", new Object[0])).func_150257_a((ITextComponent)new TextComponentString("\u00a77 ID:" + id + '\u00a7' + "r \"" + name + "\"" + '\u00a7' + "c - ")).func_150257_a((ITextComponent)end));
            return;
        }
        Client.sendData(EnumPacketServer.DialogNpcSet, this.selectedSlot, id);
    }

    @Override
    public void setGuiData(NBTTagCompound compound) {
        if (compound.func_150297_b("Slot", 3)) {
            this.data.put(compound.func_74762_e("Slot"), compound);
        }
        this.func_73866_w_();
    }
}

